define(["angular",
    "app",
    "moment"],
    function (angular,
              app,
              moment) {
	"use strict";
	app.controller("FitnessActivityController", function (formatter,
                                                          $scope,
                                                          $parse,
                                                          $state,
                                                          $stateParams,
                                                          focusService,
                                                          $window,
		                                                  HomePageConstants,
                                                          TrackersService,
                                                          FitnessConstants,
                                                          TrackersConstants,
                                                          FitnessService,
                                                          GoalGraphService,
                                                          WeeklyGoalsService,
                                                          globalDelayTracker,
                                                          $timeout,
                                                          GoalGraphAccessibilityService,
                                                          FitnessActivityGraphService,
                                                          GraphService,
                                                          FitnessRemindersService,
                                                          FitnessGoalsFHIRService) {

        var goalService = WeeklyGoalsService.instance(),
			service = FitnessService.instance($state.current.data.sectionName);


        goalService = FitnessGoalsFHIRService;

		$scope.details = {};
		$scope.globalDelayTracker = globalDelayTracker;
		focusService.focusMain();
		$scope.today = new Date();
		$scope.startDate = $scope.today;

		$scope.sectionTitle = "Fitness Activity";
        $scope.section = "fitness-activity";
        angular.extend($scope, TrackersConstants["fitness-activity"].summary);
		$scope.isPhoneView = $window.innerWidth < 768;

        goalService.fetch().then(function () {
            setDetails();
        });

		$scope.getDetails = function (item) {
            $stateParams.id = item ? service.idGetter ? service.idGetter(item) : item.id : null;
            $state.go(".entry", $stateParams);
            $stateParams.dateRange = $scope.filter.model;
		};
		$scope.showGoalHistory = function (item) {
			$stateParams.id = item ? service.idGetter(item) : null;
			$state.go('.goalhistory', $stateParams);
		};
		$scope.openGoalsModal = function (focusOptionsButton) {
			FitnessService.openGoalsModal($scope.details).then(function (details) {
				goalService.save(details).then(function () {
				    setDetails(true);
				})
			}).finally(function () {
				if (focusOptionsButton) {
					focusService.focusElement(angular.element('span.dropdown button.dropdown-toggle'));
				} else {
					focusService.focusElement(angular.element('button[title*="Goals"]'));
				}
			});
		};

        var minDate = moment().subtract(6, 'year').format('L'),
            defaultMin = moment().subtract(1, 'month').format('L'),
            defaultMax = moment().format('L'),
            defaultFilters = {
                startDate: defaultMin,
                endDate: defaultMax
            };
        $scope.parseInt = parseInt;
        $scope.allowedDateRange = { min: minDate };
        $scope.filter = {
            service: service,
            defaults: defaultFilters,
            model: angular.copy(service.dataPointers.filters),
            callbacks : {
                filter : function() {
                    makeGraph();
                }
            }
        };

        $scope.today = new Date();

        var graphMetaData = TrackersConstants["fitness-activity-legacy"].entry.vitalObservationsMeta;

        // internal functions
        var makeGraph = function() {
            if (graphMetaData) {
                $scope.graphConfig = GraphService.getGraphConfig($scope.section, service.dataPointers.filters || $scope.filter.model || $scope.filter.defaults, service.dataPointers.list, graphMetaData, $scope.sectionTitle);
            }
        };

        service.fetch($stateParams.dateRange || $scope.filter.defaults).then(function() {
            makeGraph();
        });

        function thisinit(location) {

            // array to store which slides are active, by default, first slide is active
            // this controller needs access to the active-ness of slides for 508 hiding reasons
            $scope.activeSlides = [true, false, false];

            if (!$scope.dashboard) {
                $scope.dashboard = [
                    {
                        id: 'fitness-goals',
                        title: 'Fitness Goals',
                        icon: 'icon-learnmore-fitness',
                        units: 'Weekly Activity Goal',
                        updatedField: 'effectiveDateTime',
                        expression: 'extension[4].valueString',
                        minutes: 'component[0].valueQuantity.value',
                        steps: 'extension[1].valueString',
                        miles: 'component[1].valueQuantity.value',
                        activeFlag: 'component[3].valueString',
                        startDate: 'extension[4].valueString',
                        endDate: 'extension[5].valueString',
                        type: 'target'

                    },
                    {
                        id: 'fitness-activity',
                        title: 'Fitness Activities',
                        icon: 'icon-learnmore-fitness',
                        units: 'Fitness Activity',
                        updatedField: 'effectiveDateTime',
                        minutes: 'component[0].valueQuantity.value',
                        steps: 'extension[1].valueString',
                        miles: 'component[1].valueQuantity.value',
                        type: 'progress',
                        startDate: 'effectiveDateTime'

                    },
                ];
                angular.extend($scope.details, HomePageConstants["weekly-goals"]);

                angular.forEach($scope.dashboard, function (item) {
                    item.service = TrackersService.instance(item.id);

                    if (item.id==="fitness-goals")
                    {
                        item.service.getLatest();
                    }
                    else
                    {
                        item.service.getActLatest();
                    }
                    if ($scope.details && item.type === 'target') {
                        $scope.details.target.minutes = $parse(item.minutes)(item.service.latest);
                        $scope.details.target.steps = parseFloat($parse(item.steps)(item.service.latest));
                        $scope.details.target.miles = $parse(item.miles)(item.service.latest);
                        $scope.details.startDate = $parse(item.startDate)(item.service.latest);
                        $scope.details.endDate = $parse(item.endDate)(item.service.latest);
                        $scope.endDate = $parse(item.endDate)(item.service.latest);
                    }

                    if ($scope.details && item.type === 'progress') {

                        var minutes = 0;
                        var steps = 0;
                        var miles = 0;

                        angular.forEach(item.service.latest, function (index, key) {
                            var thisresult = [];
                            thisresult.push(key);
                        });

                        // Initiated Minutes
                        if ($parse(item.minutes)(item.service.latest) === undefined) {
                            $scope.details.progress.minutes = 0;
                        }
                        else
                        {
                            $scope.details.progress.minutes = $parse(item.minutes)(item.service.latest);
                        }

                        if ($parse(item.steps)(item.service.latest) === undefined) {
                            $scope.details.progress.steps = 0;
                        }
                        else
                        {
                            $scope.details.progress.steps = parseFloat($parse(item.steps)(item.service.latest));
                        }
                        // Initiate Miles
                        if ($parse(item.miles)(item.service.latest) === undefined) {
                            $scope.details.progress.miles = 0;
                        }
                        else
                        {
                            $scope.details.progress.miles = $parse(item.miles)(item.service.latest);
                        }
                    }
                });
            }

            $scope.xsScreenResolution = function () {
                return $window.innerWidth < 768;
            };
            $scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
            $scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);
            $scope.updated = function(item) {
                $scope.$apply();
                return item.service.latest[item.updatedField];
            };
        }

        function setDetails(fetchNew) {
			if (goalService.dataPointers.list.length === 0) {
				$scope.details = goalService.createEmpty();
			} else {
				$scope.details = goalService.dataPointers.list[0];
                angular.extend($scope.details,HomePageConstants["weekly-goals"]);

                if (fetchNew) {
					goalService.fetch().then(function () {
                        $scope.statusMsg = $scope.details.endDate ? getStatusMsg($scope.details) : '';
						setDetails();
					});
				}
			}
            $scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
            $scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);
        }        

        $scope.notificationDetails = {
            notificationStatus: ''
        };

        FitnessRemindersService.init('fitness-activity');
        FitnessRemindersService.getReminder().then(function (response) {
            $scope.notificationDetails = angular.copy(response);
        });

        var trophyIconButton = {
            getLabel : function() {
                return "Set Weekly Activity Goals";
            },
			getPhoneLabel : function() {
				return "Set Goals";
			},
            getIcon : function() {
                return "icon-trophy";
            },
            onClick : function(isDropdownButton) {
                $scope.openGoalsModal(isDropdownButton);
            },
            getAriaLabel : function() {
                return "Trophy icon Weekly Activity Goals";
            },
			getPhoneAriaLabel : function() {
				return "Trophy icon Goals";
			}
        },
        tableGraphButton = {
            getLabel : function() {
                return $scope.isGraphView ? "Table" : "Graph";
            },
            getIcon : function() {
                return $scope.isGraphView ? "icon-list" : "icon-graph";
            },
            onClick : function(isDropdownButton) {
				if (isDropdownButton) {
					focusService.focusElement(angular.element('span.dropdown button.dropdown-toggle'));
				}
                $scope.isGraphView = !$scope.isGraphView;
                $scope.filter.noFocus = $scope.isGraphView;
            }
        },
        notificationButton = {
            getLabel: function() {
                return 'Notifications (' + $scope.notificationDetails.notificationStatus + ')';
            },
            getIcon: function() {
                return 'icon-notification';
            },
            onClick: function() {
                $state.go('main.auth.fitness.notification', $stateParams);
            }
        },
        goalHistoryButton = {
            getLabel : function() {
                return "Goal History";
            },
			getPhoneLabel : function() {
				return "Goal History";
			},
            getIcon : function() {
                return "icon-time";
            },
            onClick : function(isDropdownButton) {
                $scope.showGoalHistory();
            },
            getAriaLabel : function() {
                return "Time icon Goal History";
            },
			getPhoneAriaLabel : function() {
				return "Time icon Goals History";
			}
        };

        $scope.navButtons = {	
        	rightNoOptions : [trophyIconButton],		
            right : [goalHistoryButton,tableGraphButton, notificationButton]
        };

        var onViewChange = function () {
            thisinit('view-change');
            focusService.focusPrimary();
        };
        $scope.$on('$viewContentLoaded', onViewChange);
        $scope.$on('$stateChangeSuccess', onViewChange);

		angular.extend($scope, FitnessConstants[$state.current.data.sectionName].summary);

		if ($scope.details) {
            $scope.statusMsg = $scope.details.endDate ? getStatusMsg($scope.details) : '';

        }
        function getStatusMsg(details) {

            angular.extend(details,HomePageConstants["weekly-goals"]);

		    var tmpstartDate = details.startDate ? details.startDate : details.extension[4].valueString;
		    var tmpendDate = details.endDate ? details.endDate : details.extension[5].valueString;

            var msInDay = 1000 * 3600 * 24;
            var endDate = (new Date(tmpendDate)).getTime();
            var d = new Date();
            var today = (new Date((d.getMonth()+1) + '/' + d.getDate() + '/' + d.getFullYear())).getTime();
            var daysRemain = Math.round((endDate - today) / msInDay) +1;
            var startDateDate = tmpstartDate.substring(5,7) + '/' + tmpstartDate.substring(8,10) + '/' + tmpstartDate.substring(0,4);

            return 'Status:  ' + tmpstartDate + ' - ' + tmpendDate +
                ' (' + daysRemain + ' days remaining)';
        }

		if (!navigator.userAgent.match(/(iPad|iPhone|iPod)/g)) {
			angular.element($window).bind('resize.fitnessGraphResize', function () {
				$timeout(function () {
					angular.forEach(Highcharts.charts, function (chart) {
						if (chart) {
							chart.setSize(chart.chartWidth, chart.chartHeight, false);
						}
					});
				});
			});

			$scope.$on("$destroy", function () {
				$(window).off("resize.fitnessGraphResize");
			});
		};

		thisinit('root');
	});
});